# https://www.instana.com/blog/stans-robot-shop-sample-microservice-application/
# https://github.com/instana/robot-shop

from pyparsing import *
from detectors.pyparsingPatterns import *
from detectors.project import *
from detectors.detectorContext import *
from detectors.evidences import *

project = Project("Microservice Based Robot Shop", "../systems/robot-shop-master")
project.addEnvVars(DockerEnvStatements(), "./web")

cart = project.addComponent(JSExpressService(), "./cart")
catalogue = project.addComponent(JSExpressService(), "./catalogue")
dispatch = project.addComponent(GoAMQPService(), "./dispatch")
payment = project.addComponent(PythonFlaskRestfulService(), "./payment")
ratings = project.addComponent(PHPRestfulService(), "./ratings")
shipping = project.addComponent(JavaSparkService(), "./shipping")
user = project.addComponent(JSExpressService(), "./user")

apiGateway = project.addComponent(NginxAPIGateway(), "./web")
project.addLinks(NginxLocationToServiceLinks(), apiGateway, 
    [catalogue, user, cart, shipping, payment, ratings])

webClient = project.addComponent(NginxLocationsToRESTAPIClient(), "./web")
# as we have detected the component via the links to it, we use it as evidence for adding the link
project.addLink(webClient, webClient, apiGateway)

webUI = project.addComponent(NginxLocationsToWebUIClient(), "./web")
# as we have detected the component via the links to it, we use it as evidence for adding the link
project.addLink(webUI, webUI, apiGateway)

project.addLink(JSRequestLinks(), cart, catalogue)

cartAndAnonymousUserCountDB = project.addComponent(NodeJSRedisDBClient(), "./cart", name = "Cart and Anonymous User Count DB")
# as we have detected the component via the links to it, we use it as evidence for adding the link
project.addLink(cartAndAnonymousUserCountDB, cart, cartAndAnonymousUserCountDB)

# def redisDBFromJSDetector(detectorContext, **kwargs):
#     print("************ redisDBFromJSDetector ************** ")
#     args = getArgsFromKwArgs(['redisVar', 'redisClientVar'], **kwargs)
#     detectorContext.matchesPattern(Literal(args["redisVar"]) + Literal("=") + Literal("require") + Literal("(") + Literal("'") + Literal("redis") + "'" + Literal(")"))
#     detectorContext.matchesPattern(Literal(args["redisClientVar"]) + Literal("=") + Literal(args["redisVar"]) + Literal(".") + Literal("createClient"))
#     detectorContext.matchesPattern(Literal(args["redisClientVar"]) + Literal(".") +  oneOf(["setex", "get", "del"]))
#     # detect that at least one async invocation in a Promise is present too
#     detectorContext.matchesPattern(Literal("return") + Literal("new") + 
#         Literal("Promise") + roundBracesBlock + Literal(";")).matchesPattern(Literal(args["redisClientVar"]) + 
#         Literal(".") +  oneOf("setex get del"))

# def dockerComposeImageBasedService(ctx, **kwargs):
#     print("************ goFuncToConsumerRabbitChannel ************** ")
#     args = getArgsFromKwArgs(["serviceName", "imageNamePrefix"], **kwargs)
#     ctx.matchIndentedBlock(Literal("services") + Literal(":"), "no services block in docker compose file").matchIndentedBlock(
#         Literal(args["serviceName"]) + Literal(":"), "service '" + args["serviceName"] + 
#         "' block missing in services section of docker compose file").matchesPattern(Literal("image") + Literal(":") +
#         Literal(args["imageNamePrefix"]))

# cartAndAnonymousUserCountDB = project.createComponent("Cart and Anonymous User Count DB", "redisDB", "./",
#     DetectInFile("docker-compose.yaml", dockerComposeImageBasedService, serviceName = "redis", imageNamePrefix = "redis"))

# project.createLinks(cart, cartAndAnonymousUserCountDB, {"roleName": "target", "stereotypeInstances": "resp, synchronousConnector, callback", 
#     "taggedValues": "'description': 'async callback for saving cart, sync get, del, etc. for all other db operations'"}, 
#     "./cart", 
#     DetectInFile("server.js", redisDBFromJSDetector, redisVar = "redis", redisClientVar = "redisClient"))






# class JSRequestLinks(Detector):
#     def __init__(self):
#         super().__init__()
#         self.requestDetector = JSInvocation("request")
#         self.firstArgPattern = Literal("request") + Literal("(") + OneOrMore(jsString | Word(printables, excludeChars=",);"))

#     def _doDetect(self, dir, detectMethod, **kwargs):
#         options = getLinksArgs(**kwargs)
#         source = options["source"]
#         target = options["target"]

#         linkEvidences = []
#         requestEvidences = detectMethod(dir, **kwargs)
#         for re in requestEvidences:
#             for match in re.matches:
#                 ctx = DetectorContext(match.matchedText)
#                 firstArgCtx = ctx.matchesPattern(self.firstArgPattern)
#                 for argMatch, argPos in firstArgCtx.textsAndPositions:
#                     print("checking argMatch = " + str(argMatch))
#                     if containsURLToAlias(argMatch, target.aliases):
#                         linkEvidences.append(LinkEvidence(source, target, match, linkTypes = 
#                             ["restfulHTTP"], technologyTypes = ["javascript", "request"]))                        
#         return linkEvidences    

#     def detect(self, dir, **kwargs):
#         return self._doDetect(dir, self.requestDetector.detect, **kwargs)
#     def detectInMatches(self, dir, **kwargs):
#         return self._doDetect(dir, self.requestDetector.detectInMatches, **kwargs)

# class JSRequestInPromiseLinks(Detector):
#     def __init__(self):
#         super().__init__()
#         self.promiseDetector = JSInvocation("Promise")
#         self.jsRequestLinksDetector = JSRequestLinks()

#     def detect(self, dir, **kwargs):
#         options = getLinksArgs(**kwargs)
#         promiseEvidences = self.promiseDetector.detect(dir, **kwargs)
#         promiseMatches = []
#         for pe in promiseEvidences:
#             promiseMatches.extend(pe.matches)
#         linkEvidences = self.jsRequestLinksDetector.detectInMatches(promiseMatches, **kwargs)
#         for e in linkEvidences:
#             e.linkTypes = ["restfulHTTP", "callback"]
#         return linkEvidences



### TODO change to failed detectors
if project.failedEvidences != []:
    print("*** FAILED EVIDENCES / MODEL ELEMENTS NOT ADDED ***\n")
    no = 0
    for evidence in project.failedEvidences:
        no = no + 1
        print(str(no) + ": " + evidence)
    print("\n*** \n")

# print("*** RESULTING MODEL ***\n")
# print(project.genModel)
# print("*** \n")

project.saveAsFile("genmodel.py")

import subprocess
subprocess.call(['python3', 'generateAll.py'])